/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.creeperhost.minetogether.connect.lib.netty.DataUtils;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import net.creeperhost.minetogether.connect.lib.netty.packet.ServerPacketHandler;

public final class SHello
implements Packet<ServerPacketHandler> {
    public final byte[] nonce;
    public final byte[] encryptedAESKey;

    public SHello(byte[] nonce, byte[] encryptedAESKey) {
        this.nonce = nonce;
        this.encryptedAESKey = encryptedAESKey;
    }

    public SHello(ByteBuf buf) {
        this.nonce = DataUtils.readBytes(buf);
        this.encryptedAESKey = DataUtils.readBytes(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        DataUtils.writeBytes(buf, this.nonce);
        DataUtils.writeBytes(buf, this.encryptedAESKey);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, ServerPacketHandler handler) throws Exception {
        handler.handleHello(ctx, this);
    }
}

